import { ActivityLog } from '../models/index.js';
import { logger } from '../utils/logger.js';

export const logActivity = (action, resourceType) => {
  return async (req, res, next) => {
    // Store original res.json to intercept response
    const originalJson = res.json;
    
    res.json = function(data) {
      // Log activity after successful response
      if (res.statusCode >= 200 && res.statusCode < 300 && req.user) {
        setImmediate(async () => {
          try {
            await ActivityLog.logActivity({
              userId: req.user.id,
              action,
              resourceType,
              resourceId: req.params.id || data?.id,
              resourceName: req.body?.name || data?.name,
              details: {
                method: req.method,
                path: req.path,
                statusCode: res.statusCode,
                ...(req.body && { requestBody: req.body })
              },
              ipAddress: req.ip,
              userAgent: req.get('User-Agent')
            });
          } catch (error) {
            logger.error('Failed to log activity:', error);
          }
        });
      }
      
      // Call original json method
      return originalJson.call(this, data);
    };
    
    next();
  };
};

export const logFileActivity = (action) => {
  return logActivity(action, 'file');
};

export const logUserActivity = (action) => {
  return logActivity(action, 'user');
};

export const logAuthActivity = (action) => {
  return logActivity(action, 'auth');
};